/*****************************************************************************
 Host Interface module for an ASI6205 based bus mastering PCI adapter.

    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License as
    published by the Free Software Foundation;

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/

#ifndef _HPI6205_H_
#define _HPI6205_H_

#include "hpi_internal.h"

/***********************************************************
	Defines used for basic messaging
************************************************************/
#define H620_HIF_RESET		0
#define H620_HIF_IDLE		1
#define H620_HIF_GET_RESP	2
#define H620_HIF_DATA_DONE	3
#define H620_HIF_DATA_MASK	0x10
#define H620_HIF_SEND_DATA	0x14
#define H620_HIF_GET_DATA	0x15
#define H620_HIF_UNKNOWN		0x0000ffff

/***********************************************************
	Types used for mixer control caching
************************************************************/

#define H620_MAX_ISTREAMS 32
#define H620_MAX_OSTREAMS 32
#define HPI_NMIXER_CONTROLS 2048

/*********************************************************************
This is used for dynamic control cache allocation
**********************************************************************/
struct controlcache_6205 {
	uint32_t dwNumberOfControls;
	uint32_t dwPhysicalAddress32;
	uint32_t dwSizeInBytes;
};

/*********************************************************************
This is used for dynamic allocation of async event array
**********************************************************************/
struct async_event_buffer_6205 {
	uint32_t dwPhysicalAddress32;
	uint32_t dwSpare;
	struct hpi_fifo_buffer b;
};

/***********************************************************
The Host located memory buffer that the 6205 will bus master
in and out of.
************************************************************/
#define HPI6205_SIZEOF_DATA (16*1024)
#define HPI6205_SIZEOF_MSG_BODY (256 + sizeof(struct hpi_message) - sizeof(struct hpi_message_header))
#define HPI6205_SIZEOF_RESP_BODY (1024)

struct message_buffer_6205 {
	struct hpi_message_header message;  // 12 bytes
	char data[HPI6205_SIZEOF_MSG_BODY];
};

struct response_buffer_6205 {
	struct hpi_response_header response;  // 12 bytes
	char data[HPI6205_SIZEOF_RESP_BODY];
};

union buffer_6205 {
	struct message_buffer_6205 MessageBuffer;
	struct response_buffer_6205 ResponseBuffer;
	uint8_t bData[HPI6205_SIZEOF_DATA];
};

struct bus_master_interface_62 {
	uint32_t dwHostCmd;
	uint32_t dwDspAck;
	uint32_t dwTransferSizeInBytes;
	union buffer_6205 u;
	struct controlcache_6205 aControlCache;
	struct async_event_buffer_6205 aAsyncBuffer;
	struct hpi_hostbuffer_status
		aInStreamHostBufferStatus[H620_MAX_ISTREAMS];
	struct hpi_hostbuffer_status
		aOutStreamHostBufferStatus[H620_MAX_OSTREAMS];
};

#ifndef HPI_BUILD_SANITISE
typedef volatile struct bus_master_interface_62 tBusMasteringInterfaceBuffer;
typedef volatile struct async_event_buffer_6205  H620_ASYNC_EVENT_BUFFER;
typedef volatile struct controlcache_6205  H620_CONTROLCACHE;
typedef volatile struct hpi_hostbuffer_status  H620_HOSTBUFFER_STATUS;
#endif
#endif
