/** HPI Version Definitions
Development releases have odd minor version.
Production releases have even minor version.

\file hpi_version.h

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

*/

#ifndef _HPI_VERSION_H
#define _HPI_VERSION_H

/* Use single digits for versions less that 10 to avoid octal. */
/* *** HPI_VER is the only edit required to update version *** */
/** HPI version */
#define HPI_VER HPI_VERSION_CONSTRUCTOR(4, 20, 48)

/** HPI version string in dotted decimal format */
#define HPI_VER_MAJMIN_STRING "4.20"
#define HPI_VER_STRING "4.20.48"

/** Library version as documented in hpi-api-versions.txt */
#define HPI_LIB_VER  HPI_VERSION_CONSTRUCTOR(10, 4, 0)

/** Construct hpi version number from major, minor, release numbers */
#define HPI_VERSION_CONSTRUCTOR(maj, min, r) ((maj << 16 ) + (min << 8) + r)

/** Extract major version from hpi version number */
#define HPI_VER_MAJOR(v) ((int)(v >> 16))
/** Extract minor version from hpi version number */
#define HPI_VER_MINOR(v) ((int)((v >> 8) & 0xFF ))
/** Extract release from hpi version number */
#define HPI_VER_RELEASE(v) ((int)(v & 0xFF ))

#endif
